#!/bin/bash
#$ -l h_vmem=3G
#$ -l tmem=3G
#$ -S /bin/bash
#$ -j y
#$ -l h_rt=1000:00:0
#$ -pe smp 12
#$ -R y
#$ -cwd

exe=/home/jerelevy/raxml/raxml2/standard-RAxML/raxmlHPC-PTHREADS-SSE3

nsearch=100         # number of initial tree searches
replicates=1000     # number of bootstrap replicates
ncores=12           # number of cores used
alignment_name=/SAN/biosciences/oma/research/jeremy_levy/OMAStandalone/SpeciesTrees/BUSCO/Alignments/BUSCO_Complete_Concatenate_min15.fas
outdir=/SAN/biosciences/oma/research/jeremy_levy/OMAStandalone/SpeciesTrees/BUSCO/RAxML100/

# -s - alignment
# -n - output
# perform ML search based on nsearch initial parsimony trees

# -p: random seed number for the parsimony trees
$exe -m PROTCATILG -M -p 12345 -# $nsearch -s ${alignment_name} -n 100 -T 12 >> screen_out


# rm RAxML_result* RAxML_parsimony* RAxML_log*


# Perform rapid bootstraping on the ML tree
$exe -m PROTCATILG -M -p 12345 -x 12345 -# $replicates -s ${alignment_name} -n Cboot_trees -T $ncores >> screen_out


# Draw bipartitions on the best ML tree    -n = nazwa drzewa wynikowego
$exe -m PROTCATILG -f b -p 12345 -t RAxML_bestTree.100 -z RAxML_bootstrap.Cboot_trees -n CML+boot -T $ncores >> screen_out

